#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = 222;
const int add = int(1e6);

int t, step = 0, C;
int cost[N], used[N];
int p[N], ptr[N], d[N], q[N];
int c[N][N], f[N][N];

void dfs(int v) {
	used[v] = step;
	if (v == t) {
		return;
	}
	while (ptr[v] <= t) {
		if (c[v][ptr[v]] - f[v][ptr[v]] < C || d[ptr[v]] != d[v] + 1 || used[ptr[v]] == step) {
			++ptr[v];
			continue;
		}
		p[ptr[v]] = v;
		dfs(ptr[v]);
		if (used[t] == step) {
			return;
		}
		++ptr[v];
	}
}

void dfs2(int v) {
	used[v] = step;
	for (int i = 0; i <= t; ++i) {
		if (c[v][i] - f[v][i] > 0 && used[i] != step) {
			dfs2(i);
		}
	}
}

int main() {
#ifdef LOCAL42
#define TASK "F"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	int n, m, k;
	scanf("%d %d %d", &n, &m, &k);
	for (int i = 0; i < n; ++i) {
		scanf("%d", &cost[i]);
		cost[i] *= -1;
	}
	for (int i = 0; i < n; ++i) {
		int tmp;
		scanf("%d", &tmp);
	}
	for (int i = 0; i < m; ++i) {
		int a, b;
		scanf("%d %d", &a, &b);
		--a;
		--b;
		c[a][b] = inf;
	}
	int s = n;
	t = n + 1;
	for (int i = 0; i < n; ++i) {
		c[s][i] = add;
		c[i][t] = cost[i] + add;
	}
	int flow = 0;
	for (C = inf; C > 0; C /= 2) {
		for (;;) {
			for (int i = 0; i <= t; ++i) {
				d[i] = inf;
			}
			d[s] = 0;
			int l = 0, r = 1;
			q[0] = s;
			while (l < r) {
				int v = q[l++];
				for (int i = 0; i <= t; ++i) {
					if (c[v][i] - f[v][i] >= C && d[i] > d[v] + 1) {
						d[i] = d[v] + 1;
						q[r++] = i;
					}
				}
			}
			if (d[t] == inf) {
				break;
			}
			for (int i = 0; i <= t; ++i) {
				ptr[i] = 0;
			}
			for (;;) {
				++step;
				dfs(s);
				if (used[t] != step) {
					break;
				}
				int can = inf;
				for (int j = t; j != s; j = p[j]) {
					can = min(can, c[p[j]][j] - f[p[j]][j]);
				}
				flow += can;
				for (int j = t; j != s; j = p[j]) {
					f[p[j]][j] += can;
					f[j][p[j]] -= can;
				}
			}
		}
	}
	++step;
	dfs2(s);
	vi lst;
	for (int i = 0; i < n; ++i) {
		if (used[i] == step) {
			lst.pb(i);
		}
	}
	printf("%d\n%d\n", n * add - flow, sz(lst));
	for (int i = 0; i < sz(lst); ++i) {
		printf("%d ", lst[i] + 1);
	}
	puts("");
	return 0;
}
